<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn() || !hasPermission('view_products')) {
    echo json_encode(['success' => false, 'serials' => [], 'message' => 'Unauthorized']);
    exit;
}

$product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;
if ($product_id <= 0) {
    echo json_encode(['success' => false, 'serials' => [], 'message' => 'Invalid product ID']);
    exit;
}

$serials = [];

// Get serial numbers from stock_adjustments
$stmt = $pdo->prepare("SELECT serial_numbers FROM stock_adjustments WHERE product_id = ? AND serial_numbers IS NOT NULL");
$stmt->execute([$product_id]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    if (!empty($row['serial_numbers'])) {
        $arr = json_decode($row['serial_numbers'], true);
        if (is_array($arr)) {
            $serials = array_merge($serials, $arr);
        }
    }
}
// Get serial numbers from supplier_receipts
$stmt = $pdo->prepare("SELECT serial_numbers FROM supplier_receipts WHERE product_id = ? AND serial_numbers IS NOT NULL");
$stmt->execute([$product_id]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    if (!empty($row['serial_numbers'])) {
        $arr = json_decode($row['serial_numbers'], true);
        if (is_array($arr)) {
            $serials = array_merge($serials, $arr);
        }
    }
}

// Remove duplicates and empty values
$serials = array_filter(array_unique($serials));

// Return as JSON
echo json_encode(['success' => true, 'serials' => array_values($serials)]); 